@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-xl-4 col-12 dashboard-users">
                <div class="row  ">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-sm-6 col-12 dashboard-users-success">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div
                                                class="badge-circle badge-circle-lg badge-circle-light-success mx-auto mb-50">
                                                <i class="bx bx-briefcase-alt font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">Total Purchase</div>
                                            <h3 class="mb-0">{{\App\Models\Purchase::get()->count()}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div
                                                class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-user font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">Users</div>
                                            <h3 class="mb-0">{{\App\Models\User::get()->count()}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6 col-12 dashboard-users-danger">
                                <div class="card text-center">
                                    <div class="card-content">
                                        <div class="card-body py-1">
                                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                                <i class="bx bx-shopping-bag font-medium-5"></i>
                                            </div>
                                            <div class="text-muted line-ellipsis">Active Bonus</div>
                                            <?php
                                                $b = \App\Models\Bonus::where('status', 'active')->first();
                                            ?>
                                            <h3 class="mb-0" style="font-size: 13px !important;">{{$b ? $b->bonus_name : 'Bonus not Available'}}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6 col-12 dashboard-visit">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title">Visits of {{date('Y-M')}}</h4>
                        <i class="bx bx-dots-vertical-rounded font-medium-3 cursor-pointer"></i>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div id="multi-radial-chart"></div>
                            <ul class="list-inline d-flex justify-content-around mb-0">
                                <li><span class="bullet bullet-xs bullet-primary mr-50"></span>Target</li>
                                <li><span class="bullet bullet-xs bullet-danger mr-50"></span>Mart</li>
                                <li><span class="bullet bullet-xs bullet-warning mr-50"></span>Ebay</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6 col-12 dashboard-greetings">
                <div class="card">
                    <div class="card-header">
                        <h3 class="greeting-text">Congratulations {{admin()->user()->name ?? 'Admin'}}!</h3>
                        <p class="mb-0">Best seller of the month</p>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-end">
                                <div class="dashboard-content-left">
                                    <h1 class="text-primary font-large-2 text-bold-500">$89k</h1>
                                    <p>You have done 57.6% more sales today.</p>
                                    <button type="button" class="btn btn-primary glow">View Sales</button>
                                </div>
                                <div class="dashboard-content-right">
                                    <img src="{{asset(admin_file_root())}}/app-assets/images/icon/cup.png"
                                         height="220" width="220" class="img-fluid" alt="Dashboard Ecommerce"/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3 col-6 dashboard-users-danger">
                <div class="card text-center">
                    <div class="card-content">
                        <div class="card-body py-1">
                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                <i class="bx bx-notepad font-medium-5"></i>
                            </div>
                            <div class="text-muted line-ellipsis">Pending Withdraw</div>
                            <h3 class="mb-0">{{\App\Models\Withdrawal::where('status', 'pending')->get()->count()}}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-3 col-6 dashboard-users-danger">
                <div class="card text-center">
                    <div class="card-content">
                        <div class="card-body py-1">
                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                <i class="bx bx-notepad font-medium-5"></i>
                            </div>
                            <div class="text-muted line-ellipsis">Approved Withdraw</div>
                            <h3 class="mb-0">{{\App\Models\Withdrawal::where('status', 'approved')->get()->count()}}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-3 col-6 dashboard-users-danger">
                <div class="card text-center">
                    <div class="card-content">
                        <div class="card-body py-1">
                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                <i class="bx bx-notepad font-medium-5"></i>
                            </div>
                            <div class="text-muted line-ellipsis">Pending Deposit</div>
                            <h3 class="mb-0">{{\App\Models\Deposit::where('status', 'pending')->get()->count()}}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-3 col-6 dashboard-users-danger">
                <div class="card text-center">
                    <div class="card-content">
                        <div class="card-body py-1">
                            <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                                <i class="bx bx-notepad font-medium-5"></i>
                            </div>
                            <div class="text-muted line-ellipsis">Approved Deposit</div>
                            <h3 class="mb-0">{{\App\Models\Deposit::where('status', 'approved')->get()->count()}}</h3>
                        </div>
                    </div>
                </div>
            </div>
<!-- Profelar: Popup Section ONLY -->
<style>
  .pt-overlay{
    position:fixed; inset:0; z-index:9999; display:none;
    align-items:center; justify-content:center; padding:16px;
    background:rgba(0,0,0,.6);
  }
  .pt-overlay.active{ display:flex; }

  .pt-card{
    position:relative; width:min(520px,96vw);
    border-radius:22px; padding:24px 22px 22px;
    background:rgba(255,255,255,.1);
    border:1px solid rgba(255,255,255,.2);
    color:#fff; box-shadow:0 20px 60px rgba(0,0,0,.35);
    backdrop-filter: blur(14px) saturate(140%);
    -webkit-backdrop-filter: blur(14px) saturate(140%);
  }
  .pt-close{
    position:absolute; top:10px; right:10px; width:38px; height:38px;
    border-radius:12px; border:1px solid rgba(255,255,255,.25);
    background:rgba(255,255,255,.12); color:#fff; cursor:pointer;
    display:grid; place-items:center; font-size:22px; line-height:1;
    transition:transform .15s ease, background .2s ease;
  }
  .pt-close:hover{ background:rgba(255,255,255,.2); transform:rotate(90deg); }

  .pt-badge{
    display:inline-block; font-size:12px; letter-spacing:.3px;
    padding:6px 10px; border-radius:999px; margin-bottom:10px;
    background:rgba(59,130,246,.18); border:1px solid rgba(59,130,246,.35);
    color:#eaf1ff;
  }
  .pt-title{ font-size:24px; font-weight:800; margin:6px 0 8px; }
  .pt-sub{ font-size:14px; opacity:.92; margin-bottom:16px; }

  .pt-actions{ display:grid; gap:10px; grid-template-columns:1fr; }
  .pt-btn{
    display:inline-flex; align-items:center; justify-content:center;
    padding:13px 16px; border-radius:14px; font-weight:800; text-decoration:none;
    background:#a7f3d0; color:#052e22; border:1px solid #6ee7b7;
    box-shadow:0 10px 26px rgba(167,243,208,.28);
    transition:transform .12s ease, box-shadow .2s ease;
  }
  .pt-btn:hover{ transform:translateY(-1px); box-shadow:0 14px 30px rgba(167,243,208,.34); }

  .pt-small{ font-size:12px; opacity:.8; margin-top:8px; display:flex; justify-content:space-between; align-items:center; }
  .pt-dont-show{
    cursor:pointer; font-weight:600; text-decoration:underline; opacity:.85;
  }
</style>

<div id="profelar-popup" class="pt-overlay" role="dialog" aria-modal="true" aria-labelledby="pt-title">
  <div class="pt-card" role="document">
    <button class="pt-close" aria-label="Close popup" type="button">&times;</button>

    <span class="pt-badge">Welcome</span>
    <div id="pt-title" class="pt-title">This Website Developed by Profelar Technology</div>
    <div class="pt-sub">Want to make a new website? Get a fast, modern and responsive site from Profelar Technology.</div>

    <div class="pt-actions">
      <a class="pt-btn" href="https://profelar.com" target="_blank" rel="noopener">ORDER NOW</a>
    </div>

    <div class="pt-small">
      <span>Visit us: profelar.com</span>
      <span class="pt-dont-show" id="pt-dont-show">Don't show again</span>
    </div>
  </div>
</div>

<script>
(function(){
  const overlay = document.getElementById('profelar-popup');
  const closeBtn = overlay.querySelector('.pt-close');
  const dontShowBtn = document.getElementById('pt-dont-show');
  const storageKey = 'profelarPopupDismissed';

  function close(){
    overlay.classList.remove('active');
  }

  // Close popup normally
  closeBtn.addEventListener('click', close);
  overlay.addEventListener('click', (e)=>{ if(e.target===overlay) close(); });

  // Don't show again
  dontShowBtn.addEventListener('click', ()=>{
    localStorage.setItem(storageKey, 'true');
    close();
  });

  // Show popup automatically after X seconds (optional timer)
  const showDelay = 2000; // 2 seconds
  if(!localStorage.getItem(storageKey)){
    setTimeout(()=>{ overlay.classList.add('active'); }, showDelay);
  }

})();
</script>
        </div>
    </section>
@endsection
