<!doctype html>
<html lang="en">
<head>
    <meta data-n-head="ssr" charset="utf-8">
    <meta data-n-head="ssr" name="viewport" content="width=device-width, initial-scale=1">
    <meta data-n-head="ssr" data-hid="description" name="description" content="{{env('APP_NAME')}} APP">
    <title>{{env('APP_NAME')}}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="stylesheet" href="{{asset('public/records.css')}}">
    <style>
        .records-page-content {
            padding: 32px 16px 100px;
            padding-top: 0;
        }
    </style>
</head>
<body>
<div id="__nuxt">
    <div id="__layout">
        <div>
            <section class="records-page flex flex-col">
                <div class="records-page-content flex-1">
                    <div class="records-page-content-balance">
                        <div class="flex items-center justify-between">
                            <div>
                                <div class="lable">Your Available Balance</div>
                                <div class="value bold">{{price(auth()->user()->balance)}}</div>
                            </div>
                            <div class="btn" onclick="window.location.href='{{route('user.recharge')}}'">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                                     fill="none">
                                    <path d="M0.278711 8.28582C0.278711 12.3757 3.62438 15.7214 7.71429 15.7214C7.88498 15.7214 8.03888 15.6638 8.15048 15.5522C8.26209 15.4406 8.31964 15.2867 8.31964 15.1161C8.31964 14.9454 8.26209 14.7915 8.15048 14.6799C8.03888 14.5683 7.88498 14.5107 7.71429 14.5107C4.24541 14.5107 1.48941 11.7547 1.48941 8.28582C1.48941 4.81695 4.24541 2.06094 7.71429 2.06094C11.1832 2.06094 13.9392 4.81695 13.9392 8.28582C13.9392 8.45651 13.9967 8.61041 14.1083 8.72202C14.2199 8.83362 14.3738 8.89117 14.5445 8.89117C14.7152 8.89117 14.8691 8.83362 14.9807 8.72202C15.0923 8.61041 15.1499 8.45651 15.1499 8.28582C15.1499 4.19591 11.8042 0.850244 7.71429 0.850244C3.62438 0.850244 0.278711 4.19591 0.278711 8.28582Z"
                                          fill="#0000A0" stroke="#0000A0" stroke-width="0.3"></path>
                                    <path d="M8.16922 12.5338H14.5441C14.7148 12.5338 14.8687 12.4763 14.9803 12.3647C15.0919 12.2531 15.1494 12.0992 15.1494 11.9285C15.1494 11.7578 15.0919 11.6039 14.9803 11.4923C14.8687 11.3807 14.7148 11.3231 14.5441 11.3231H8.16922C7.99852 11.3231 7.84462 11.3807 7.73302 11.4923C7.62142 11.6039 7.56387 11.7578 7.56387 11.9285C7.56387 12.0992 7.62142 12.2531 7.73302 12.3647C7.84462 12.4763 7.99852 12.5338 8.16922 12.5338Z"
                                          fill="#0000A0" stroke="#0000A0" stroke-width="0.3"></path>
                                    <path d="M10.7514 15.1159C10.7514 15.2866 10.8089 15.4405 10.9205 15.5521C11.0321 15.6637 11.186 15.7212 11.3567 15.7212C11.5274 15.7212 11.6813 15.6637 11.7929 15.5521C11.9045 15.4405 11.9621 15.2866 11.9621 15.1159V8.74099C11.9621 8.5703 11.9045 8.4164 11.7929 8.3048C11.6813 8.1932 11.5274 8.13564 11.3567 8.13564C11.186 8.13564 11.0321 8.1932 10.9205 8.3048C10.8089 8.4164 10.7514 8.5703 10.7514 8.74099V15.1159Z"
                                          fill="#0000A0" stroke="#0000A0" stroke-width="0.3"></path>
                                    <path d="M6.42411 11.1239C6.50289 11.2027 6.60894 11.2324 6.68765 11.2455C6.76828 11.2589 6.84681 11.2589 6.89193 11.2589H6.89445C6.89639 11.2589 6.89842 11.2589 6.90053 11.2589C6.94369 11.259 7.02035 11.2592 7.09814 11.2203C7.17715 11.1808 7.23904 11.1119 7.29086 11.015C7.5143 10.7743 7.50859 10.4181 7.27373 10.1832L5.37626 8.28574L7.71408 5.94792L9.61155 7.84538C9.85226 8.0861 10.2204 8.0861 10.4612 7.84538C10.7019 7.60467 10.7019 7.23648 10.4612 6.99576L8.09335 4.62795C7.85264 4.38723 7.48445 4.38723 7.24373 4.62795L4.05629 7.81539C3.97751 7.89418 3.94783 8.00023 3.93471 8.07894C3.92128 8.15957 3.92128 8.2381 3.92129 8.28321L3.92129 8.28574L3.92129 8.28826C3.92128 8.33337 3.92128 8.41191 3.93471 8.49254C3.94783 8.57124 3.97751 8.67729 4.05629 8.75608L6.42411 11.1239Z"
                                          fill="#0000A0" stroke="#0000A0" stroke-width="0.3"></path>
                                </svg>
                                <span>Deposit</span>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div>
                                <div class="lable">Total Withdraw</div>
                                <div class="value bold">
                                    <?php
                                    $totalWithdraw = \App\Models\Withdrawal::where('user_id', auth()->id())->where('status', 'approved')->sum('amount');
                                    ?>
                                    {{price($totalWithdraw)}}
                                </div>
                            </div>
                            <div class="btn" onclick="window.location.href='{{route('user.withdraw')}}'">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"
                                     fill="none">
                                    <path d="M10.008 1.43413C7.78935 1.4583 5.66975 2.35663 4.10938 3.93409C2.54901 5.51155 1.67383 7.64081 1.67383 9.85963C1.67383 12.0784 2.54901 14.2077 4.10938 15.7852C5.66975 17.3626 7.78935 18.261 10.008 18.2851H16.443C16.5531 18.285 16.6609 18.2547 16.7549 18.1974C16.8488 18.1402 16.9252 18.0582 16.9757 17.9604C17.0262 17.8627 17.0488 17.7529 17.0411 17.6432C17.0334 17.5334 16.9957 17.4279 16.932 17.3381L15.532 15.3611C15.4865 15.2968 15.4287 15.2422 15.362 15.2002C15.2953 15.1583 15.221 15.1299 15.1433 15.1166C15.0656 15.1034 14.9861 15.1056 14.9093 15.1231C14.8324 15.1406 14.7598 15.1731 14.6955 15.2186C14.6313 15.2642 14.5766 15.322 14.5346 15.3887C14.4927 15.4554 14.4643 15.5297 14.451 15.6074C14.4378 15.685 14.44 15.7646 14.4575 15.8414C14.475 15.9182 14.5075 15.9908 14.553 16.0551L15.283 17.0851H10.008C8.50508 17.0833 7.04021 16.6122 5.81792 15.7376C4.59563 14.863 3.67693 13.6286 3.19007 12.2067C2.70321 10.7847 2.67248 9.24629 3.10218 7.80606C3.53188 6.36584 4.40056 5.09573 5.58695 4.17304C6.77334 3.25035 8.21823 2.72112 9.71992 2.65925C11.2216 2.59738 12.7051 3.00594 13.9634 3.82791C15.2217 4.64988 16.1919 5.84423 16.7386 7.24422C17.2853 8.64421 17.3813 10.18 17.013 11.6371C16.9922 11.714 16.9868 11.7942 16.9973 11.8732C17.0077 11.9521 17.0338 12.0282 17.0739 12.097C17.1141 12.1658 17.1676 12.2258 17.2312 12.2737C17.2948 12.3216 17.3673 12.3564 17.4445 12.376C17.5217 12.3956 17.6021 12.3996 17.6808 12.3878C17.7596 12.376 17.8352 12.3487 17.9033 12.3074C17.9714 12.266 18.0306 12.2116 18.0774 12.1472C18.1242 12.0827 18.1578 12.0096 18.176 11.9321C18.4907 10.6885 18.5174 9.38941 18.2541 8.13387C17.9909 6.87833 17.4446 5.6994 16.657 4.68685C15.8693 3.6743 14.861 2.85482 13.7088 2.29081C12.5566 1.72679 11.2909 1.43311 10.008 1.43213V1.43413Z"
                                          fill="#0000A0"></path>
                                    <path d="M10.3643 15.1799C10.0241 15.1799 9.70991 14.9979 9.54072 14.7027L7.59951 11.3164C7.5343 11.2027 7.5 11.0738 7.5 10.9427C7.5 10.5278 7.83639 10.1914 8.25134 10.1914H8.27142C8.57999 10.1914 8.84999 10.1485 9.08142 10.0628C9.32142 9.96854 9.51856 9.83569 9.67284 9.66426C9.8357 9.49283 9.94713 9.28712 10.0071 9.04712H7.97571C7.71298 9.04712 7.5 8.83414 7.5 8.57141C7.5 8.30868 7.71298 8.0957 7.97571 8.0957H9.99427C9.94284 7.87284 9.85284 7.6757 9.72427 7.50428C9.60427 7.33285 9.44141 7.19999 9.2357 7.10571C9.03856 7.00285 8.79856 6.95142 8.51571 6.95142H7.97571C7.71298 6.95142 7.5 6.73844 7.5 6.47571C7.5 6.21298 7.71298 6 7.97571 6H12.8228C13.0855 6 13.2985 6.21298 13.2985 6.47571C13.2985 6.73844 13.0855 6.95142 12.8228 6.95142H11.28C11.4257 7.11428 11.5457 7.28999 11.64 7.47856C11.7428 7.66713 11.8114 7.87284 11.8457 8.0957H12.8228C13.0855 8.0957 13.2985 8.30868 13.2985 8.57141C13.2985 8.83414 13.0855 9.04712 12.8228 9.04712H11.8714C11.7857 9.6814 11.5414 10.1785 11.1385 10.5385C10.7357 10.89 10.2171 11.13 9.58284 11.2585L11.163 13.7174C11.569 14.3492 11.1153 15.1799 10.3643 15.1799Z"
                                          fill="#0000A0"></path>
                                </svg>
                                <span>Withdraw</span>
                            </div>
                        </div>
                    </div>
                    <div class="records-page-content-routers">
                        <div class="records-page-content-routers-item" onclick="window.location.href='{{route('record')}}'">
                            <div class="icon">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                         fill="none">
                                        <path d="M10.6789 24.5205C6.12525 24.5205 2.43183 22.4867 2.40945 19.9765C2.40945 20.9358 2.40625 21.7768 2.40625 21.7768C2.40625 24.2999 6.10926 26.3432 10.6757 26.3432C15.2453 26.3432 18.9451 24.2999 18.9451 21.7768V19.9541C18.9483 22.4771 15.2485 24.5205 10.6789 24.5205ZM10.6789 27.6959C6.12525 27.6959 2.43183 25.6653 2.40945 23.1519C2.40945 24.1112 2.40625 24.9522 2.40625 24.9522C2.40625 27.4752 6.10926 29.5186 10.6757 29.5186C15.2453 29.5186 18.9451 27.4752 18.9451 24.9522V23.1327C18.9483 25.6525 15.2485 27.6959 10.6789 27.6959Z"
                                              fill="#0000A0"></path>
                                        <path d="M21.2631 22.4036C20.9977 22.4036 20.7355 22.394 20.4765 22.3812C20.4669 22.4611 20.4669 22.5411 20.4541 22.621C20.5085 22.7809 20.5372 22.9536 20.5372 23.1327V24.2039C20.7771 24.2167 21.0201 24.2231 21.2663 24.2231C25.8359 24.2231 29.5357 22.1797 29.5357 19.6567V17.8372C29.5357 20.3602 25.8327 22.4036 21.2631 22.4036Z"
                                              fill="#0000A0"></path>
                                        <path d="M21.2631 19.228C20.9977 19.228 20.7355 19.2184 20.4765 19.2056C20.4669 19.2856 20.4669 19.3655 20.4541 19.4455C20.5085 19.6054 20.5372 19.778 20.5372 19.9571V21.0284C20.7771 21.0412 21.0201 21.0476 21.2663 21.0476C25.8359 21.0476 29.5357 19.0042 29.5357 16.4811V14.6616C29.5357 17.1847 25.8327 19.228 21.2631 19.228Z"
                                              fill="#0000A0"></path>
                                        <path d="M21.2638 12.8743C16.7102 12.8743 13.0168 10.8405 12.9944 8.33025C12.9944 9.28957 12.9912 10.1306 12.9912 10.1306C12.9912 11.2082 13.6723 12.1963 14.8011 12.9766C15.9459 13.29 16.9628 13.7281 17.8102 14.2749C18.8623 14.5403 20.0295 14.6938 21.2606 14.6938C25.8302 14.6938 29.53 12.6504 29.53 10.1274V8.30786C29.5364 10.8341 25.8334 12.8743 21.2638 12.8743Z"
                                              fill="#0000A0"></path>
                                        <path d="M21.2631 16.0527C20.7067 16.0527 20.1663 16.0208 19.6387 15.9632C20.0576 16.542 20.3422 17.1751 20.4605 17.8499C20.7259 17.8659 20.9913 17.8723 21.2599 17.8723C25.8295 17.8723 29.5293 15.8289 29.5293 13.3059V11.4863C29.5357 14.0094 25.8327 16.0527 21.2631 16.0527Z"
                                              fill="#0000A0"></path>
                                        <path d="M21.2636 2.38867C16.6971 2.38867 12.9941 4.43204 12.9941 6.95508C12.9941 9.47811 16.6971 11.5215 21.2636 11.5215C25.8332 11.5215 29.533 9.47811 29.533 6.95508C29.5362 4.43204 25.8332 2.38867 21.2636 2.38867Z"
                                              fill="#0000A0"></path>
                                        <path d="M10.6786 14.0349C6.11219 14.0349 2.40918 16.0783 2.40918 18.6013C2.40918 21.1243 6.11219 23.1677 10.6786 23.1677C15.2482 23.1677 18.948 21.1243 18.948 18.6013C18.948 16.0751 15.2482 14.0349 10.6786 14.0349Z"
                                              fill="#0000A0"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="title bold truncate">Task Records</div>
                        </div>
                        <div class="records-page-content-routers-item" onclick="window.location.href='{{route('deposit.record')}}'">
                            <div class="icon">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                         fill="none">
                                        <path d="M13.2374 4.14258C12.7678 4.14258 12.3028 4.23507 11.869 4.41477C11.4351 4.59448 11.0409 4.85787 10.7089 5.18991C10.3768 5.52195 10.1135 5.91615 9.93375 6.34998C9.75405 6.78382 9.66156 7.2488 9.66156 7.71838C9.66156 8.18796 9.75405 8.65294 9.93375 9.08678C10.1135 9.52061 10.3768 9.9148 10.7089 10.2468C11.0409 10.5789 11.4351 10.8423 11.869 11.022C12.3028 11.2017 12.7678 11.2942 13.2374 11.2942C14.1857 11.2942 15.0952 10.9174 15.7658 10.2468C16.4364 9.57626 16.8131 8.66674 16.8131 7.71838C16.8131 6.77002 16.4364 5.8605 15.7658 5.18991C15.0952 4.51932 14.1857 4.14258 13.2374 4.14258ZM13.2374 9.24781L11.7071 7.71838L13.2374 6.18812L14.7668 7.71838L13.2374 9.24781ZM19.9844 1.59981C19.654 1.59558 19.326 1.657 19.0195 1.78053C18.713 1.90405 18.434 2.08722 18.1988 2.31939C17.9637 2.55157 17.7769 2.82814 17.6495 3.13305C17.5221 3.43795 17.4564 3.76514 17.4564 4.09561C17.4564 4.42608 17.5221 4.75326 17.6495 5.05817C17.7769 5.36308 17.9637 5.63965 18.1988 5.87183C18.434 6.104 18.713 6.28717 19.0195 6.41069C19.326 6.53421 19.654 6.59564 19.9844 6.5914C20.6408 6.58299 21.2675 6.31634 21.7286 5.8492C22.1898 5.38206 22.4484 4.75205 22.4484 4.09561C22.4484 3.43917 22.1898 2.80916 21.7286 2.34202C21.2675 1.87488 20.6408 1.60823 19.9844 1.59981ZM19.9844 5.1633L18.9165 4.09581L19.9844 3.02792L21.0519 4.09581L19.9844 5.1633ZM29.5996 15.1998H2.39961C2.18744 15.1998 1.98395 15.2841 1.83392 15.4341C1.68389 15.5842 1.59961 15.7876 1.59961 15.9998V23.7331C1.59961 23.7331 2.13294 26.9857 3.46628 28.2131C5.75961 30.3239 7.94628 30.3998 7.94628 30.3998H24.0529C24.0529 30.3998 26.2396 30.3239 28.5329 28.2131C29.8663 26.9857 30.3996 23.7331 30.3996 23.7331V15.9998C30.3996 15.7876 30.3153 15.5842 30.1653 15.4341C30.0153 15.2841 29.8118 15.1998 29.5996 15.1998ZM15.9996 26.9857L11.8138 22.7998L15.9996 18.6131L20.1859 22.7994L15.9996 26.9857ZM12.7052 14.0798C11.9697 12.6398 10.5453 11.8308 8.90833 11.8308C7.2714 11.8308 5.84699 12.6398 5.1114 14.0798H12.7052ZM20.5083 14.0798L22.5916 11.9965L24.6745 14.0798H27.8761C27.7814 11.1998 25.4523 8.97048 22.592 8.97048C19.7309 8.97048 17.4023 11.1998 17.3071 14.0798H20.5087H20.5083Z"
                                              fill="#BD25E3"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="title bold truncate">Deposit Records</div>
                        </div>
                        <div class="records-page-content-routers-item" onclick="window.location.href='{{route('withdraw.record')}}'">
                            <div class="icon">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                         fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M30.5846 27.9347C30.8891 27.6302 31.0601 27.2172 31.0601 26.7865V13.172H1V26.7865C1.00036 27.2171 1.17155 27.6298 1.47597 27.9343C1.78039 28.2387 2.19317 28.4099 2.62368 28.4102H29.4365C29.8671 28.4102 30.2801 28.2392 30.5846 27.9347ZM1.00137 10.7736H31.0601L31.0615 5.62231C31.0608 5.19203 30.8894 4.77961 30.5851 4.47548C30.2807 4.17136 29.8681 4.00036 29.4378 4H2.62506C2.19478 4.00036 1.78221 4.17136 1.47783 4.47548C1.17344 4.77961 1.0021 5.19203 1.00137 5.62231V10.7736ZM9.47398 18.5445H5.66477V22.3454H9.47398V18.5445ZM16.5291 18.5445H12.7212V22.3454H16.5291V18.5445Z"
                                              fill="#F46B6B"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="title bold truncate">Withdraw Records</div>
                        </div>
                        <div class="records-page-content-routers-item" onclick="window.location.href='{{route('earning.record')}}'">
                            <div class="icon">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                         fill="none">
                                        <path d="M22.6935 1H9.5292C7.53233 1 5.61725 1.79325 4.20525 3.20525C2.79325 4.61725 2 6.53233 2 8.5292V23.7273C2 24.716 2.19476 25.6949 2.57316 26.6083C2.95156 27.5217 3.50619 28.3516 4.20536 29.0506C4.90454 29.7496 5.73456 30.304 6.64804 30.6822C7.56151 31.0604 8.54054 31.2549 9.5292 31.2547H22.699C23.6875 31.2547 24.6663 31.06 25.5796 30.6817C26.4928 30.3034 27.3226 29.749 28.0216 29.05C28.7206 28.351 29.2751 27.5212 29.6534 26.6079C30.0316 25.6946 30.2263 24.7158 30.2263 23.7273V8.5292C30.2263 7.54015 30.0315 6.56079 29.6529 5.64706C29.2743 4.73334 28.7193 3.90317 28.0198 3.20397C27.3203 2.50477 26.4898 1.95025 25.5759 1.57209C24.662 1.19392 23.6826 0.999524 22.6935 1ZM16.1077 24.9483C15.3789 24.9354 14.6701 24.7074 14.0705 24.2929C13.4709 23.8784 13.0072 23.2959 12.7376 22.6186C12.4681 21.9413 12.4048 21.1995 12.5556 20.4863C12.7065 19.7731 13.0647 19.1204 13.5854 18.6103C14.1061 18.1002 14.766 17.7553 15.4821 17.6191C16.1982 17.4828 16.9386 17.5613 17.6102 17.8447C18.2819 18.128 18.8547 18.6035 19.2569 19.2115C19.6591 19.8195 19.8725 20.5328 19.8705 21.2617C19.8662 21.7515 19.7655 22.2356 19.5741 22.6864C19.3826 23.1373 19.1043 23.546 18.7548 23.8892C18.4054 24.2324 17.9918 24.5033 17.5376 24.6866C17.0834 24.8699 16.5975 24.9619 16.1077 24.9574V24.9483ZM25.0992 10.0187C22.5826 11.6941 19.6226 12.5786 16.5994 12.5587C11.4687 12.5623 7.4301 10.2165 7.17066 10.0659C6.82926 9.86259 6.58261 9.532 6.48496 9.14685C6.38731 8.7617 6.44667 8.35353 6.64996 8.01214C6.85326 7.67074 7.18384 7.42409 7.569 7.32644C7.95415 7.2288 8.36232 7.28815 8.70371 7.49144C10.2395 8.3187 11.8907 8.9107 13.6022 9.24765C17.2997 9.98424 20.6125 9.40731 23.4501 7.53136C23.781 7.32775 24.1782 7.26086 24.5577 7.34481C24.9371 7.42876 25.269 7.65699 25.4832 7.98122C25.6973 8.30545 25.777 8.70027 25.7054 9.0822C25.6337 9.46413 25.4164 9.80323 25.0992 10.0278V10.0187Z"
                                              fill="#EDB959"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="title bold truncate">Earnings Records</div>
                        </div>
                        <div class="records-page-content-routers-item" onclick="window.location.href='{{route('reward.record')}}'">
                            <div class="icon">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                         fill="none">
                                        <path d="M7.49375 21.8188C9.34062 23.1969 11.45 24.1375 13.6969 24.5906L10.0719 30.8687L9.4 28.3625C9.25 27.7969 8.8875 27.3281 8.38125 27.0375C8.04375 26.8438 7.66875 26.7437 7.29375 26.7437C7.10312 26.7437 6.9125 26.7687 6.72188 26.8156L4.21875 27.4937L7.49375 21.8188ZM24.2 21.25C22.4406 22.7375 20.4 23.7937 18.2062 24.3781L21.9562 30.875L22.6281 28.3656C22.9406 27.2 24.1438 26.5094 25.3031 26.8219L27.8031 27.5L24.2 21.25ZM15.5562 8.55937C13.6906 8.55937 12.1687 10.0781 12.1687 11.9469C12.1687 13.8125 13.6875 15.3344 15.5562 15.3344C17.4219 15.3344 18.9438 13.8156 18.9438 11.9469C18.9438 10.0781 17.4219 8.55937 15.5562 8.55937ZM16.75 22.6594L15.7937 22.7656L15.1281 22.7406C12.4656 22.6344 9.95312 21.5719 8.05625 19.7469L7.5875 19.2938C5.7375 17.2844 4.72188 14.6937 4.72188 11.9469C4.72188 9.05312 5.84687 6.33125 7.89687 4.28438C9.94375 2.23438 12.6625 1.10938 15.5562 1.10938C18.45 1.10938 21.1719 2.23438 23.2188 4.28438C25.2687 6.33438 26.3937 9.05 26.3937 11.9469C26.3937 14.3344 25.625 16.6062 24.2062 18.4781L23.5531 19.1969C21.7969 21.1344 19.3781 22.3656 16.75 22.6594ZM21.65 11.9438C21.65 8.58438 18.9156 5.85 15.5562 5.85C12.1969 5.85 9.4625 8.58438 9.4625 11.9438C9.4625 15.3031 12.1969 18.0375 15.5562 18.0375C18.9187 18.0406 21.65 15.3063 21.65 11.9438Z"
                                              fill="#2BC59F"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="title bold truncate">Reward Records</div>
                        </div>
                        <div class="records-page-content-routers-item" onclick="window.location.href='{{route('financial.record')}}'">
                            <div class="icon">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                         fill="none">
                                        <path d="M5.90624 5.28012H26.1322C26.8282 5.28012 27.3962 4.76212 27.3962 4.12812C27.3962 3.49412 26.8282 2.97412 26.1322 2.97412H5.90624C5.21024 2.97412 4.64024 3.49012 4.64024 4.12412C4.64024 4.75612 5.21024 5.27812 5.90624 5.27812V5.28012ZM28.1222 7.58812H3.84024C3.50216 7.59181 3.17927 7.72913 2.94207 7.97007C2.70487 8.21101 2.57264 8.53602 2.57424 8.87412V28.0281C2.5721 28.3662 2.70383 28.6914 2.94065 28.9328C3.17747 29.1741 3.50016 29.3119 3.83824 29.3161H28.1182C28.457 29.313 28.7807 29.1756 29.0184 28.9342C29.2561 28.6927 29.3884 28.3669 29.3862 28.0281V8.87212C29.3876 8.70465 29.3558 8.53856 29.2929 8.38336C29.23 8.22815 29.1371 8.08688 29.0195 7.96762C28.9019 7.84837 28.7619 7.75346 28.6076 7.68834C28.4533 7.62322 28.2877 7.58917 28.1202 7.58812H28.1222Z"
                                              fill="#2F5BDB"></path>
                                        <path d="M16.0437 26.0001C15.488 26.0001 14.9748 25.7028 14.6984 25.2207L11.5278 19.6896C11.4213 19.5038 11.3652 19.2934 11.3652 19.0793C11.3652 18.4015 11.9147 17.8521 12.5924 17.8521H12.6252C13.1292 17.8521 13.5702 17.7821 13.9482 17.6421C14.3402 17.4881 14.6622 17.2711 14.9142 16.9911C15.1802 16.7111 15.3622 16.3751 15.4602 15.9831H12.1422C11.7131 15.9831 11.3652 15.6352 11.3652 15.2061C11.3652 14.777 11.7131 14.4291 12.1422 14.4291H15.4392C15.3552 14.0651 15.2082 13.7431 14.9982 13.4631C14.8022 13.1831 14.5362 12.9661 14.2002 12.8121C13.8782 12.6441 13.4862 12.5601 13.0242 12.5601H12.1422C11.7131 12.5601 11.3652 12.2122 11.3652 11.7831C11.3652 11.354 11.7131 11.0061 12.1422 11.0061H20.0592C20.4884 11.0061 20.8362 11.354 20.8362 11.7831C20.8362 12.2122 20.4884 12.5601 20.0592 12.5601H17.5392C17.7772 12.8261 17.9732 13.1131 18.1272 13.4211C18.2952 13.7291 18.4072 14.0651 18.4632 14.4291H20.0592C20.4884 14.4291 20.8362 14.777 20.8362 15.2061C20.8362 15.6352 20.4884 15.9831 20.0592 15.9831H18.5052C18.3652 17.0191 17.9662 17.8311 17.3082 18.4191C16.6502 18.9931 15.8032 19.3851 14.7672 19.5951L17.3481 23.6113C18.0113 24.6432 17.2703 26.0001 16.0437 26.0001Z"
                                              fill="white"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="title bold truncate">Financial Records</div>
                        </div>
                    </div>
                </div>
                @include('app.layout.menu')
            </section>
        </div>
    </div>
</div>

</body>
</html>
