<!DOCTYPE html>
<html lang="en">

<head>

  <!-- Meta -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">

  <!-- Favicons Icon -->
  <link rel="shortcut icon" type="image/x-icon" href="/IMG_20250918_172903_494.jpg">
  
  <!-- Title -->
  <title>Home</title>

  <!-- PWA Version -->
  <!--<link rel="manifest" href="manifest.json">-->

  <!-- Stylesheets -->
  <link rel="stylesheet" type="text/css" href="/assets/app/css/style.css?v=191">
  <link rel="stylesheet" href="/assets/app/vendor/swiper/swiper-bundle.min.css">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/toastify-js" type="223dd0e92e4dc0849129cee5-text/javascript"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
</head>

<body data-theme-color="color-orange">
  <div class="page-wraper">


    <style>
      .header .header-content .mid-content {
        flex: 1;
        text-align: left;
      }

      .header {
        background-color: #925bf9;
        min-height: 55px;
        z-index: 2;
        border-bottom: 0px solid #dddddd;
      }

      #preloader {
        top: 0;
      }

      i.fa-solid.fa-bell {
        font-size: 22px;
        color: white;
        margin-top: 12px;
        padding-right: 7px;
      }

      i.fa-solid.fa-globe {
        font-size: 22px;
        color: white;
        margin-top: 12px;
        padding-right: 7px;
      }

      .header .sticky-header {
        top: 0px;
        background: #ffffff00;
      }

      .toastify {
        padding: 12px 20px;
        color: #ffffff;
        display: inline-block;
        box-shadow: 0 3px 6px -1px rgba(0, 0, 0, 0.12), 0 10px 36px -4px rgba(77, 96, 232, 0.3);
        background: rgb(36, 6, 89);
        top: 15px;
        border-radius: 10px;
        position: fixed;
        opacity: 0;
        transition: all 0.4s cubic-bezier(0.215, 0.61, 0.355, 1);
        cursor: pointer;
        text-decoration: none;
        max-width: 90%;
        z-index: 2147483647;
      }

      .toastify.on {
        opacity: 1;
      }

      .toast-close {
        opacity: 0.4;
        padding: 0 5px;
      }

      .toastify-right {
        right: 15px;
      }

      .toastify-left {
        left: 15px;
      }

      .toastify-top {
        top: 15px;
      }

      .toastify-bottom {
        bottom: 15px;
      }

      .toastify-rounded {
        border-radius: 25px;
      }

      .toastify-avatar {
        width: 1.5em;
        height: 1.5em;
        margin: 0 5px;
        border-radius: 2px;
      }

      .toastify-center {
        margin-left: auto;
        margin-right: auto;
        left: 0;
        right: 0;
        max-width: fit-content;
      }

      * {
        user-select: none;
      }
    </style>


    <!-- Header -->
    <header class="header">
      <div class="main-bar">
        <div class="container">
          <div class="header-content">

            <div class="mid-content">
              <h5 class="mb-0">foxconn88</h5>
            </div>
            <!--              <div class="right-content">-->
            <!--                  <a href="javascript:void(0);" class="menu-toggler">-->
            <!--	<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">-->
            <!--		<path opacity="0.4" d="M16.0755 2H19.4615C20.8637 2 22 3.14585 22 4.55996V7.97452C22 9.38864 20.8637 10.5345 19.4615 10.5345H16.0755C14.6732 10.5345 13.537 9.38864 13.537 7.97452V4.55996C13.537 3.14585 14.6732 2 16.0755 2Z" fill="#a19fa8"/>-->
            <!--		<path fill-rule="evenodd" clip-rule="evenodd" d="M4.53852 2H7.92449C9.32676 2 10.463 3.14585 10.463 4.55996V7.97452C10.463 9.38864 9.32676 10.5345 7.92449 10.5345H4.53852C3.13626 10.5345 2 9.38864 2 7.97452V4.55996C2 3.14585 3.13626 2 4.53852 2ZM4.53852 13.4655H7.92449C9.32676 13.4655 10.463 14.6114 10.463 16.0255V19.44C10.463 20.8532 9.32676 22 7.92449 22H4.53852C3.13626 22 2 20.8532 2 19.44V16.0255C2 14.6114 3.13626 13.4655 4.53852 13.4655ZM19.4615 13.4655H16.0755C14.6732 13.4655 13.537 14.6114 13.537 16.0255V19.44C13.537 20.8532 14.6732 22 16.0755 22H19.4615C20.8637 22 22 20.8532 22 19.44V16.0255C22 14.6114 20.8637 13.4655 19.4615 13.4655Z" fill="#a19fa8"/>-->
            <!--	</svg>-->
            <!--</a>-->
            <!--              </div>-->
          </div>
        </div>
      </div>
    </header>


    <!-- Sidebar -->
    <div class="sidebar">
      <div class="author-box mb-2">
        <div class="dz-media">
          <img src="/assets/profile.png" class="rounded-circle" alt="author-image">
        </div>
        <div class="dz-info">
          <span>Good Morning</span>
          <h5 class="name">MD Goljar </h5>
        </div>
      </div>
      <ul class="nav navbar-nav">


        <li><a class="nav-link" onclick="if (!window.__cfRLUnblockHandlers) return false; navigate('/');" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <span class="dz-icon bg-pink light">
              <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9.14373 20.7821V17.7152C9.14372 16.9381 9.77567 16.3067 10.5584 16.3018H13.4326C14.2189 16.3018 14.8563 16.9346 14.8563 17.7152V20.7732C14.8562 21.4473 15.404 21.9951 16.0829 22H18.0438C18.9596 22.0023 19.8388 21.6428 20.4872 21.0007C21.1356 20.3586 21.5 19.4868 21.5 18.5775V9.86585C21.5 9.13139 21.1721 8.43471 20.6046 7.9635L13.943 2.67427C12.7785 1.74912 11.1154 1.77901 9.98539 2.74538L3.46701 7.9635C2.87274 8.42082 2.51755 9.11956 2.5 9.86585V18.5686C2.5 20.4637 4.04738 22 5.95617 22H7.87229C8.19917 22.0023 8.51349 21.8751 8.74547 21.6464C8.97746 21.4178 9.10793 21.1067 9.10792 20.7821H9.14373Z" fill="#130F26" />
              </svg>
            </span>
            <span>Home</span>
          </a></li>


        <li><a class="nav-link" onclick="if (!window.__cfRLUnblockHandlers) return false; navigate('/home/team');" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <span class="dz-icon bg-orange light">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" viewBox="0 0 24 24" version="1.1" class="svg-main-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                  <polygon points="0 0 24 0 24 24 0 24" />
                  <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#fff" fill-rule="nonzero" />
                  <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#fff" opacity="0.5" />
                </g>
              </svg>
            </span>
            <span>Team</span>
          </a></li>
        <li><a class="nav-link" onclick="if (!window.__cfRLUnblockHandlers) return false; navigate('/home/products');" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <span class="dz-icon bg-skyblue light">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18" height="18" viewBox="0 0 24 24" version="1.1" class="svg-main-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                  <rect x="0" y="0" width="24" height="24" />
                  <rect fill="#00aeff" x="4" y="4" width="7" height="7" rx="1.5" />
                  <path d="M5.5,13 L9.5,13 C10.3284271,13 11,13.6715729 11,14.5 L11,18.5 C11,19.3284271 10.3284271,20 9.5,20 L5.5,20 C4.67157288,20 4,19.3284271 4,18.5 L4,14.5 C4,13.6715729 4.67157288,13 5.5,13 Z M14.5,4 L18.5,4 C19.3284271,4 20,4.67157288 20,5.5 L20,9.5 C20,10.3284271 19.3284271,11 18.5,11 L14.5,11 C13.6715729,11 13,10.3284271 13,9.5 L13,5.5 C13,4.67157288 13.6715729,4 14.5,4 Z M14.5,13 L18.5,13 C19.3284271,13 20,13.6715729 20,14.5 L20,18.5 C20,19.3284271 19.3284271,20 18.5,20 L14.5,20 C13.6715729,20 13,19.3284271 13,18.5 L13,14.5 C13,13.6715729 13.6715729,13 14.5,13 Z" fill="#fff" opacity="0.5" />
                </g>
              </svg>
            </span>
            <span>Products</span>
          </a></li>
        <li><a class="nav-link" onclick="if (!window.__cfRLUnblockHandlers) return false; navigate('/home/notifications');" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <span class="dz-icon bg-green light">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18" height="18" viewBox="0 0 24 24" version="1.1" class="svg-main-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                  <path d="M17,12 L18.5,12 C19.3284271,12 20,12.6715729 20,13.5 C20,14.3284271 19.3284271,15 18.5,15 L5.5,15 C4.67157288,15 4,14.3284271 4,13.5 C4,12.6715729 4.67157288,12 5.5,12 L7,12 L7.5582739,6.97553494 C7.80974924,4.71225688 9.72279394,3 12,3 C14.2772061,3 16.1902508,4.71225688 16.4417261,6.97553494 L17,12 Z" fill="#fff" />
                  <rect fill="#fff" opacity="0.3" x="10" y="16" width="4" height="4" rx="2" />
                </g>
              </svg>
            </span>
            <span>Notification</span>

          </a></li>
        <li><a class="nav-link" onclick="if (!window.__cfRLUnblockHandlers) return false; navigate('/home/profile');" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <span class="dz-icon bg-yellow light">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18" height="18" viewBox="0 0 24 24" version="1.1" class="svg-main-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                  <polygon points="0 0 24 0 24 24 0 24" />
                  <path d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z" fill="#fff" fill-rule="nonzero" opacity="0.3" />
                  <path d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z" fill="#fff" fill-rule="nonzero" />
                </g>
              </svg>
            </span>
            <span>Profile</span>
          </a></li>
        <li><a class="nav-link" onclick="if (!window.__cfRLUnblockHandlers) return false; navigate('/home/help');" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <span class="dz-icon bg-skyblue light">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18" height="18" viewBox="0 0 24 24" version="1.1" class="svg-main-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                  <rect x="0" y="0" width="24" height="24" />
                  <path d="M21.9999843,15.009808 L22.0249378,15 L22.0249378,19.5857864 C22.0249378,20.1380712 21.5772226,20.5857864 21.0249378,20.5857864 C20.7597213,20.5857864 20.5053674,20.4804296 20.317831,20.2928932 L18.0249378,18 L6,18 C4.34314575,18 3,16.6568542 3,15 L3,6 C3,4.34314575 4.34314575,3 6,3 L19,3 C20.6568542,3 22,4.34314575 22,6 L22,15 C22,15.0032706 21.9999948,15.0065399 21.9999843,15.009808 Z" fill="#fff" opacity="0.3" />
                  <path d="M7.5,12 C6.67157288,12 6,11.3284271 6,10.5 C6,9.67157288 6.67157288,9 7.5,9 C8.32842712,9 9,9.67157288 9,10.5 C9,11.3284271 8.32842712,12 7.5,12 Z M12.5,12 C11.6715729,12 11,11.3284271 11,10.5 C11,9.67157288 11.6715729,9 12.5,9 C13.3284271,9 14,9.67157288 14,10.5 C14,11.3284271 13.3284271,12 12.5,12 Z M17.5,12 C16.6715729,12 16,11.3284271 16,10.5 C16,9.67157288 16.6715729,9 17.5,9 C18.3284271,9 19,9.67157288 19,10.5 C19,11.3284271 18.3284271,12 17.5,12 Z" fill="#fff" opacity="0.3" />
                </g>
              </svg>
            </span>
            <span>Help & Support</span>

          </a></li>
        <li>
          <a class="nav-link" href="/home/logout">
            <span class="dz-icon bg-red light">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18" height="18" viewBox="0 0 24 24" version="1.1" class="svg-main-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                  <rect x="0" y="0" width="24" height="24" />
                  <path d="M14.0069431,7.00607258 C13.4546584,7.00607258 13.0069431,6.55855153 13.0069431,6.00650634 C13.0069431,5.45446114 13.4546584,5.00694009 14.0069431,5.00694009 L15.0069431,5.00694009 C17.2160821,5.00694009 19.0069431,6.7970243 19.0069431,9.00520507 L19.0069431,15.001735 C19.0069431,17.2099158 17.2160821,19 15.0069431,19 L3.00694311,19 C0.797804106,19 -0.993056895,17.2099158 -0.993056895,15.001735 L-0.993056895,8.99826498 C-0.993056895,6.7900842 0.797804106,5 3.00694311,5 L4.00694793,5 C4.55923268,5 5.00694793,5.44752105 5.00694793,5.99956624 C5.00694793,6.55161144 4.55923268,6.99913249 4.00694793,6.99913249 L3.00694311,6.99913249 C1.90237361,6.99913249 1.00694311,7.89417459 1.00694311,8.99826498 L1.00694311,15.001735 C1.00694311,16.1058254 1.90237361,17.0008675 3.00694311,17.0008675 L15.0069431,17.0008675 C16.1115126,17.0008675 17.0069431,16.1058254 17.0069431,15.001735 L17.0069431,9.00520507 C17.0069431,7.90111468 16.1115126,7.00607258 15.0069431,7.00607258 L14.0069431,7.00607258 Z" fill="#fff" fill-rule="nonzero" opacity="0.3" transform="translate(9.006943, 12.000000) scale(-1, 1) rotate(-90.000000) translate(-9.006943, -12.000000) " />
                  <rect fill="#ff4db8" opacity="0.3" transform="translate(14.000000, 12.000000) rotate(-270.000000) translate(-14.000000, -12.000000) " x="13" y="6" width="2" height="12" rx="1" />
                  <path d="M21.7928932,9.79289322 C22.1834175,9.40236893 22.8165825,9.40236893 23.2071068,9.79289322 C23.5976311,10.1834175 23.5976311,10.8165825 23.2071068,11.2071068 L20.2071068,14.2071068 C19.8165825,14.5976311 19.1834175,14.5976311 18.7928932,14.2071068 L15.7928932,11.2071068 C15.4023689,10.8165825 15.4023689,10.1834175 15.7928932,9.79289322 C16.1834175,9.40236893 16.8165825,9.40236893 17.2071068,9.79289322 L19.5,12.0857864 L21.7928932,9.79289322 Z" fill="#fff" fill-rule="nonzero" transform="translate(19.500000, 12.000000) rotate(-90.000000) translate(-19.500000, -12.000000) " />
                </g>
              </svg>
            </span>
            <span>Logout</span>
          </a>
        </li>

        <li class="nav-label">Settings</li>

        <li>
          <div class="mode">
            <span class="dz-icon bg-green light">
              <i class="fa-solid fa-moon"></i>
            </span>
            <span>Dark Mode</span>
            <div class="custom-switch">
              <input type="checkbox" class="switch-input theme-btn" id="toggle-dark-menu">
              <label class="custom-switch-label" for="toggle-dark-menu"></label>
            </div>
          </div>
        </li>
      </ul>
      <div class="sidebar-bottom">
        <h6 class="name">foxconn88</h6>
        <p>App Version 1.0</p>
      </div>
    </div>
    <!-- Sidebar End -->



    <!--   <div id="preloader">-->
    <!--	<div class="spinner"></div>-->
    <!--</div>-->
    <!-- Theme Color -->
    <meta name="theme-color" content="#310d64">

    <!-- Fonts and Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">

    <style>
      /* Base Styles */
      :root {
        --primary-blue: #310d64;
        --dark-blue: #115a4b;
        --light-blue: #3d82ff;
        --accent-blue: #64b5f6;
        --text-light: #ffffff;
        --text-dark: #333333;
        --primary-color: #310d64;
        --secondary-color: #0c453a;
        --accent-color: #1a7560;
        --text-color: #333;
        --card-bg: rgba(255, 255, 255, 0.9);
        --shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
      }
      
      

      body {
        background-color: #f5f7fa;
        font-family: 'Poppins', sans-serif;
        color: var(--text-dark);
        min-height: 100vh;
        margin: 0;
        padding: 0;
      }

      /* Header Styles */
      .header {
        background: linear-gradient(135deg, #310d64, #140047);
        min-height: 180px;
        border-bottom-left-radius: 25px;
        border-bottom-right-radius: 25px;
        box-shadow: 0 4px 20px rgba(0, 85, 238, 0.3);
        position: relative;
        overflow: hidden;
      }

      /* Important Notice Popup Styles */
      .notice-popup {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.9);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
      }

      .notice-content {
        background-color: white;
        border-radius: 15px;
        width: 90%;
        max-width: 500px;
        padding: 25px;
        position: relative;
        box-shadow: 0 5px 25px rgba(0, 0, 0, 0.3);
        animation: popIn 0.4s ease-out;
      }

      @keyframes popIn {
        0% {
          transform: scale(0.8);
          opacity: 0;
        }

        100% {
          transform: scale(1);
          opacity: 1;
        }
      }

      .notice-close {
        position: absolute;
        top: -3px;
        right: 13px;
        font-size: 32px;
        color: #ff0000;
        cursor: pointer;
        background: none;
        border: none;
        font-weight: bold;
      }

      .notice-title {
        color: #2d0a61;
        font-size: 1.8rem;
        margin-bottom: 15px;
        text-align: center;
        font-weight: 700;
        border-bottom: 2px solid #2d0962;
        padding-bottom: 10px;
      }

      .notice-message {
        color: #333;
        font-size: 1rem;
        line-height: 1.6;
        margin-bottom: 20px;
        text-align: center;
      }

      .notice-highlight {
        color: #2d0a61;
        font-weight: 600;
      }

      .notice-btn {
        background-color: #2d0a61;
        color: white;
        border: none;
        padding: 12px 25px;
        border-radius: 12px;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        display: block;
        margin: 0 auto;
        transition: all 0.3s ease;
        width: 80%;
        max-width: 200px;
        box-shadow: rgba(255, 255, 255, 0.1) 5px -1px 9px inset, rgb(255 255 255 / 7%) 0 3px 9px inset, rgba(255, 255, 255, 0.6) 0 1px 1px inset, rgb(0 0 0 / 5%) 0 -8px 36px inset, rgba(255, 255, 255, 0.6) 0 1px 5px inset, rgb(0 0 0 / 10%) 2px 19px 31px;
      }

      .notice-btn:hover {
        background-color: #0d4a3d;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
      }

      /* Main Content Container */
      .main-container {
        margin-top: -130px;
        position: relative;
        z-index: 2;
        padding-bottom: 100px;
      }

      /* Card Styles */
      .card {
        background: white;
        border-radius: 16px;
        /*box-shadow: 0 6px 15px rgba(0, 102, 255, 0.1);*/
        transition: all 0.3s ease;
        overflow: hidden;
        margin-bottom: 20px;
        border: none;
      }

      .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 25px rgba(0, 102, 255, 0.2);
      }

      /* Swiper Slider Styles */
      .swiper-container {
        width: 100%;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
      }

      .swiper-slide img {
        width: 100%;
        height: 180px;
        object-fit: cover;
        display: block;
      }

      .swiper-pagination-bullet {
        background: white !important;
        opacity: 0.6 !important;
      }

      .swiper-pagination-bullet-active {
        background: var(--accent-blue) !important;
        opacity: 1 !important;
      }

      /* Marquee Styles */
      .marquee-container {
        background: rgb(46 11 98 / 7%);
        border-radius: 12px;
        padding: 10px 15px;
        margin: 15px 0;
        overflow: hidden;
      }

      .marquee-content {
        display: inline-block;
        white-space: nowrap;
        animation: marquee 55s linear infinite;
        padding-left: 100%;
      }

      @keyframes marquee {
        0% {
          transform: translateX(0);
        }

        100% {
          transform: translateX(-100%);
        }
      }

      .marquee-item {
        display: inline-block;
        margin-right: 40px;
        color: var(--primary-blue);
        font-weight: 500;
      }

      /* Quick Access Buttons */
      .quick-access {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 10px;
        margin: 20px 0;
      }

      .quick-btn {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        background: white;
        border-radius: 12px;
        padding: 15px 5px;
        text-decoration: none;
        color: var(--text-dark);
        transition: all 0.3s ease;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
        border: 1px #ffffff solid;
      }

      .quick-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
        color: var(--primary-blue);
      }

      .quick-btn i {
        font-size: 24px;
        margin-bottom: 8px;
        color: var(--primary-blue);
      }

      .quick-btn span {
        font-size: 12px;
        font-weight: 500;
      }

      /* News Section */
      .news-card {
        padding: 15px;
      }

      .news-title {
        font-size: 18px;
        font-weight: 600;
        color: var(--primary-blue);
        margin-bottom: 5px;
        display: flex;
        align-items: center;
      }

      .news-title i {
        margin-right: 10px;
      }

      .news-item {
        display: flex;
        align-items: center;
        padding: 10px 0;
        border-bottom: 1px solid #f0f0f0;
      }

      .news-item:last-child {
        border-bottom: none;
      }

      .news-date {
        background: var(--primary-blue);
        color: white;
        width: 40px;
        height: 40px;
        border-radius: 8px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin-right: 12px;
        flex-shrink: 0;
      }

      .news-date-day {
        font-size: 16px;
        font-weight: 700;
        line-height: 1;
      }

      .news-date-month {
        font-size: 10px;
        line-height: 1;
        margin-top: 2px;
      }

      .news-content {
        font-size: 13px;
        line-height: 1.4;
      }

      /* Popup Styles */
      .popup-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.7);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 2200;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s ease;
      }

      .popup-overlay.active {
        opacity: 1;
        visibility: visible;
      }

      .popup-content {
        background: white;
        padding: 48px;
        border-radius: 21px;
        width: 80%;
        max-width: 300px;
        text-align: center;
        position: relative;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        border: 0px #105a4b solid;
      }

      .popup-content h3 {
        color: #300c65;
        margin-bottom: 10px;
        font-size: 19px;
        font-weight: bold;
      }

      .popup-content p {
        color: #666;
        margin-bottom: 20px;
        font-size: 0.9rem;
      }

      .telegram-btn {
        background: #310c65;
        color: white;
        padding: 12px 20px;
        border-radius: 12px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.2s ease;
        box-shadow: rgba(255, 255, 255, 0.1) 5px -1px 9px inset, rgb(255 255 255 / 7%) 0 3px 9px inset, rgba(255, 255, 255, 0.6) 0 1px 1px inset, rgb(0 0 0 / 5%) 0 -8px 36px inset, rgba(255, 255, 255, 0.6) 0 1px 5px inset, rgb(0 0 0 / 10%) 2px 19px 31px;
      }

      .telegram-btn i {
        font-size: 1.2rem;
      }

      .close-btn {
        position: absolute;
        top: 12px;
        right: 12px;
        background: #a70000;
        border: none;
        color: #ffffff;
        font-size: 17px;
        cursor: pointer;
        padding: 0px 7px;
        border-radius: 9px;
      }

      /* Floating Action Button */
      .fab {
        position: fixed;
        right: -18px;
        bottom: 140px;
        width: 71px;
        height: 50px;
        background: var(--primary-blue);
        color: white;
        border-radius: 20%;
        display: flex;
        align-items: center;
        box-shadow: 0 6px 20px rgb(48 12 99 / 9%);
        z-index: 1001;
        transition: all 0.3s ease;
        justify-content: flex-start;
        font-size: 32px;
        padding-left: 10px;
      }
      
      .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
        gap: 20px;
        margin-top: 20px;
      }

      .product-card {
        background: white;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0px 9px 20px 14px rgba(0, 0, 0, 24%);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        position: relative;
      }

      .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
      }

      .product-badge {
        position: absolute;
        top: 15px;
        right: 15px;
        background: #310d64;
        color: white;
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        z-index: 2;
        border: 1px #ffffff8a solid;
      }

      .product-scam {
        position: absolute;
        top: 36%;
        left: 0px;
        background: #da0000;
        color: white;
        padding: 5px 33px;
        border-radius: 0px 19px 0px 0px;
        font-size: 11px;
        font-weight: 600;
        z-index: 2;
        border: 0px #ffffff8a solid;
      }

      .product-image-container {
        height: 160px;
        overflow: hidden;
        position: relative;
      }

      .product-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
      }

      .product-card:hover .product-image {
        transform: scale(1.05);
      }

      .product-content {
        padding: 20px;
      }

      .product-title {
        font-size: 18px;
        font-weight: 600;
        color: var(--secondary-color);
        margin-bottom: 10px;
      }

      .product-description {
        color: #666;
        font-size: 13px;
        line-height: 1.5;
        margin-bottom: -25px;
        min-height: 60px;
        font-weight: bold;
      }

      .product-stats {
        display: flex;
        justify-content: space-between;
        margin-bottom: 2px;
        background: #f8f9fa;
        padding: 12px;
        border-radius: 10px;
      }

      .stat-item {
        text-align: center;
      }

      .stat-value {
        font-size: 18px;
        font-weight: 700;
        color: var(--primary-color);
      }

      .stat-label {
        font-size: 12px;
        color: #777;
      }

      .product-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding-top: 15px;
        border-top: 1px solid #eee;
      }

      .product-price {
        font-size: 20px;
        font-weight: 700;
        color: var(--primary-color);
      }

      b,
      strong,
      .strong {
        font-weight: 500;
        font-size: 12px;
        color: #545454;
      }

      .invest-btn {
        background: var(--primary-color);
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 20px;
        font-weight: 600;
        font-size: 13px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: rgba(255, 255, 255, 0.1) 5px -1px 9px inset, rgb(255 255 255 / 7%) 0 3px 9px inset, rgba(255, 255, 255, 0.6) 0 1px 1px inset, rgb(0 0 0 / 5%) 0 -8px 36px inset, rgba(255, 255, 255, 0.6) 0 1px 5px inset, rgb(0 0 0 / 10%) 2px 19px 31px;
      }

      .invest-btn:hover {
        background: var(--secondary-color);
        transform: translateY(-2px);
      }

      .invest-btn:active {
        transform: translateY(0);
      }


      /* Responsive Adjustments */
      @media (max-width: 768px) {
        .quick-access {
          grid-template-columns: repeat(4, 1fr);
        }

        .plans-grid {
          grid-template-columns: 1fr;
        }

        .swiper-slide img {
          height: 180px;
        }
      }

      @media (max-width: 480px) {
        .quick-access {
          grid-template-columns: repeat(4, 1fr);
          gap: 8px;
        }

        .quick-btn {
          padding: 12px 5px;
        }

        .quick-btn i {
          font-size: 27px;
        }

        .quick-btn span {
          font-size: 10px;
        }

        .notice-title {
          font-size: 1.2rem;
        }

        .notice-message {
          font-size: 0.9rem;
        }
      }
    </style>

    <!-- Important Notice Popup -->
    <div class="notice-popup" id="noticePopup">
      <div class="notice-content">
        <button class="notice-close">&times;</button>
        <h2 class="notice-title">IMPORTANT NOTICE</h2>
        <div class="notice-message">
          <p>Welcome to <span class="notice-highlight">FOXCONN STORE</span>!</p>
          <p>We're excited to announce our <span class="notice-highlight"> </span>  .</p>
          <p>50 taka bonus when you create an account. <span class="notice-highlight"></span></p>
          <p>Minimum Withdraw amount: <span class="notice-highlight">৳180</span></p>
          <p>Minimum recharge amount: <span class="notice-highlight">৳300</span></p>
          <p>Withdrawal charge <span class="notice-highlight">8%</span></p>
             <p>Unlimited daily withdrawal.<span class="notice-highlight"></span></p>
        </div>
        <button class="notice-btn" id="telegramBtn">
          Telegram Group
        </button>
      </div>
    </div>

    <!-- Main Content -->
    <div class="main-container">
      <div class="container">
        <!-- Swiper Slider -->
        <div class="swiper-container mb-3">
          <div class="swiper-wrapper">
            <div class="swiper-slide">
              <img src="/photo_2025-09-16_22-00-27.jpg" alt="Slider Image">
            </div>
            <div class="swiper-slide">
              <img src="/photo_2025-09-16_18-21-33.jpg" alt="Slider Image">
            </div>
          </div>
          <div class="swiper-pagination"></div>
        </div>

        <!-- Marquee Announcement -->
        <div class="marquee-container">
          <div class="marquee-content">
            <span class="marquee-item">
              <i class="fa-solid fa-microphone-lines"></i> New investment plan launched ✧ Refer friends and earn 27%% commission ✧ Minimum Withdraw- 180৳ ✧ Minimum Recharge - 300৳ ✧ Daily Income Daily Withdrawal
            </span>
            <span class="marquee-item">
              <i class="fa-solid fa-microphone-lines"></i> New investment plan launched ✧ Refer friends and earn 27% commission ✧ Minimum Withdraw- 180৳✧ Minimum Recharge 300৳ ✧ Daily Income Daily Withdrawal
            </span>
            <span class="marquee-item">
              <i class="fa-solid fa-microphone-lines"></i> New investment plan launched ✧ Refer friends and earn 27% commission ✧ Minimum Withdraw- 180৳ ✧ Minimum Recharge - 300৳ ✧ Daily Income Daily Withdrawal
            </span>
            <span class="marquee-item">
              <i class="fa-solid fa-microphone-lines"></i> New investment plan launched ✧ Refer friends and earn 27% commission ✧ Minimum Withdraw- 180৳ ✧ Minimum Recharge - 300৳✧ Daily Income Daily Withdrawal
            </span>
            <span class="marquee-item">
              <i class="fa-solid fa-microphone-lines"></i> New investment plan launched ✧ Refer friends and earn 27% commission ✧ Minimum Withdraw- 180৳ ✧ Minimum Recharge - 300৳ ✧ Daily Income Daily Withdrawal
            </span>
          </div>
        </div>

        <!-- Quick Access Buttons -->
        <div class="quick-access">
          <a href="/promo" class="quick-btn"  data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <i class="fa-solid fa-circle-dollar-to-slot"></i>
            <span>Bonus Code</span>
          </a>
          <a href="/invite" class="quick-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <i class="fa-solid fa-envelope-open-text"></i>
            <span>Invite</span>
          </a>
          <a href="/user/recharge" class="quick-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <i class="fas fa-wallet"></i>
            <span>Recharge</span>
          </a>
          <a href="/withdraw" class="quick-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">
            <i class="fa-solid fa-vault"></i>
            <span>Withdraw</span>
          </a>
          <!--<a href="/my/vip" class="quick-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">-->
          <!--  <i class="fas fa-boxes"></i>-->
          <!--  <span>Orders</span>-->
          <!--</a>-->
          <!--<a href="/tasks" class="quick-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">-->
          <!--  <i class="fa-solid fa-clipboard-list"></i>-->
          <!--  <span>Mission</span>-->
          <!--</a>-->
          <!--<a href="/promo" class="quick-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">-->
          <!--  <i class="fa-solid fa-gift"></i>-->
          <!--  <span>Gift Code</span>-->
          <!--</a>-->
          <!--<a onclick=" showTelegramPopup()" class="quick-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">-->
          <!--  <i class="fa-solid fa-paper-plane"></i>-->
          <!--  <span>Group</span>-->
          <!--</a>-->
        </div>
        
        <?php
            use \App\Models\PackageCategory;
            use \App\Models\Package;
            $menu = PackageCategory::get()->toArray();
            $packageOne = Package::where('Status', '!=','inactive')->where('tab','vip')->limit(1)->get();
            $packagetwo = Package::where('Status', '!=','inactive')->where('tab', 'fixed')->get();
            $packagethree = Package::where('Status', '!=','inactive')->where('tab', 'event')->get();
        ?>  
        


     
          <div class="">
            <div class="products-grid">
               @if($packageOne->count() > 0)
                    @foreach($packageOne as $key=>$element)
                        <?php
                            $myVip = \App\Models\Purchase::where('user_id', auth()->id())->where('package_id', $element->id)->where('status', 'active')->first();
                            $ddIncome = $element->commission_with_avg_amount != 0 ? $element->commission_with_avg_amount / $element->validity : 0;
                        ?>  
                  <div class="product-card">
                    <span class="product-badge">{{ $element->validity }} Days</span>
                    <div class="product-image-container">
                      <img src="{{asset($element->photo)}}" class="product-image" alt="Product 'A'">
                    </div>
                    <div class="product-content">
                      <!--<h3 class="product-title">Product 'A'</h3>-->
                      <p class="product-description">{{ $element->name }}</p>
        
                      <div class="product-stats">
                        <div class="stat-item">
                          <div class="stat-value">{{price($element->daily_limit)}}</div>
                          <div class="stat-label">Daily Income</div>
                        </div>
                        <div class="stat-item">
                          <div class="stat-value">{{ $element->daily_limit * $element->validity }}</div>
                          <div class="stat-label">Total Income</div>
                        </div>
                      </div>
        
                      <div class="product-footer">
                        <div class="product-price"><strong>Price:</strong> {{price($element->price)}}</div>
                        @if($myVip)
                        <button class="invest-btn" onclicked="openModal({&quot;id&quot;:&quot;7&quot;,&quot;sub_01&quot;:&quot;15&quot;,&quot;sub_02&quot;:&quot;15&quot;,&quot;image&quot;:&quot;{{asset($element->photo)}}&quot;,&quot;name&quot;:&quot;Product &#039;A&#039;&quot;,&quot;description&quot;:&quot;Daily income Daily Withdrawal&quot;,&quot;price&quot;:&quot;300&quot;,&quot;daily_income&quot;:&quot;125&quot;,&quot;days&quot;:&quot;3&quot;,&quot;type&quot;:&quot;welfare&quot;,&quot;vip&quot;:&quot;0&quot;,&quot;limit&quot;:&quot;1&quot;,&quot;active&quot;:&quot;1&quot;,&quot;home&quot;:&quot;0&quot;,&quot;time&quot;:null})" data-cf-modified-ab449d95ba8d2d80705faff4-="">
                          Current </button>
                          @else
                             @if($element->status == 'coming')
                              <button class="invest-btn" data-cf-modified-ab449d95ba8d2d80705faff4-="">
                              Comming </button>
                             @else
                              <button class="invest-btn" onclick="window.location.href = '/purchase/confirmation/{{ $element->id }}'" onclicked="openModal({&quot;id&quot;:&quot;7&quot;,&quot;sub_01&quot;:&quot;15&quot;,&quot;sub_02&quot;:&quot;15&quot;,&quot;image&quot;:&quot;{{asset($element->photo)}}&quot;,&quot;name&quot;:&quot;Product &#039;A&#039;&quot;,&quot;description&quot;:&quot;Daily income Daily Withdrawal&quot;,&quot;price&quot;:&quot;300&quot;,&quot;daily_income&quot;:&quot;125&quot;,&quot;days&quot;:&quot;3&quot;,&quot;type&quot;:&quot;welfare&quot;,&quot;vip&quot;:&quot;0&quot;,&quot;limit&quot;:&quot;1&quot;,&quot;active&quot;:&quot;1&quot;,&quot;home&quot;:&quot;0&quot;,&quot;time&quot;:null})" data-cf-modified-ab449d95ba8d2d80705faff4-="">
                              Invest Now </button>
                              @endif
                         @endif
                      </div>
                    </div>
                  </div>
                  @endforeach
              @endif
             
            </div>
        
           
          </div>
       
        
        <div id="telegramPopup" class="popup-overlay">
          <div class="popup-content">
            <h3>Join Our Telegram</h3>
            <p>Get the latest updates and exclusive offers</p>
            <a href="/profelar.php" target="_blank" class="telegram-btn">
              <i class="fab fa-telegram"></i> Join Telegram
            </a>
            <button onclick="closePopup()" class="close-btn" data-cf-modified-223dd0e92e4dc0849129cee5-="">
              <i class="fas fa-times"></i>
            </button>
          </div>
        </div>

        <!-- News Section -->
        <!--<div class="card news-card mt-5">-->
        <!--  <div class="news-title">-->
        <!--    <i class="fas fa-newspaper"></i> Latest News-->
        <!--  </div>-->
        <!--  <div class="news-items">-->
        <!--    <div class="news-item">-->
        <!--      <div class="news-date">-->
        <!--        <div class="news-date-day">25</div>-->
        <!--        <div class="news-date-month">JUL</div>-->
        <!--      </div>-->
        <!--      <div class="news-content">-->
        <!--        Product Launch - foxconn88 introduces next-gen solar analytics platform for real-time performance monitoring.-->
        <!--      </div>-->
        <!--    </div>-->
        <!--    <div class="news-item">-->
        <!--      <div class="news-date">-->
        <!--        <div class="news-date-day">20</div>-->
        <!--        <div class="news-date-month">JUL</div>-->
        <!--      </div>-->
        <!--      <div class="news-content">-->
        <!--        Global Expansion - foxconn88 opens new offices in Singapore and California to support growing demand.-->
        <!--      </div>-->
        <!--    </div>-->
        <!--    <div class="news-item">-->
        <!--      <div class="news-date">-->
        <!--        <div class="news-date-day">18</div>-->
        <!--        <div class="news-date-month">JUL</div>-->
        <!--      </div>-->
        <!--      <div class="news-content">-->
        <!--        Recognition - foxconn88 wins “CleanTech Innovation Award” for AI-driven solar efficiency solutions.-->
        <!--      </div>-->
        <!--    </div>-->
        <!--    <div class="news-item">-->
        <!--      <div class="news-date">-->
        <!--        <div class="news-date-day">15</div>-->
        <!--        <div class="news-date-month">JUL</div>-->
        <!--      </div>-->
        <!--      <div class="news-content">-->
        <!--        Major Partnership - foxconn88 partners with leading energy utilities to scale solar adoption.-->
        <!--      </div>-->
        <!--    </div>-->
        <!--    <div class="news-item">-->
        <!--      <div class="news-date">-->
        <!--        <div class="news-date-day">12</div>-->
        <!--        <div class="news-date-month">JUL</div>-->
        <!--      </div>-->
        <!--      <div class="news-content">-->
        <!--        Sustainability Shift - foxconn88 announces carbon-neutral operations across all facilities.-->
        <!--      </div>-->
        <!--    </div>-->
        <!--    <div class="news-item">-->
        <!--      <div class="news-date">-->
        <!--        <div class="news-date-day">08</div>-->
        <!--        <div class="news-date-month">JUL</div>-->
        <!--      </div>-->
        <!--      <div class="news-content">-->
        <!--        Funding Round - foxconn88 secures $50M Series B to accelerate R&D and global reach.-->
        <!--      </div>-->
        <!--    </div>-->
        <!--    <div class="news-item">-->
        <!--      <div class="news-date">-->
        <!--        <div class="news-date-day">05</div>-->
        <!--        <div class="news-date-month">JUL</div>-->
        <!--      </div>-->
        <!--      <div class="news-content">-->
        <!--        Tech Upgrade - AI-powered predictive maintenance tool now available for solar farms worldwide.-->
        <!--      </div>-->
        <!--    </div>-->
        <!--  </div>-->
        <!--</div>-->


        <!-- Floating Action Button -->
        <a href="/profelar.php" class="fab" target="_blank">
          <i class="fab fa-telegram-plane"></i>
        </a>

        <!-- Improved Footer Navigation -->
        <div class="menubar-area">
          <div class="toolbar-inner menubar-nav">
            <a href="/" class="nav-link " data-cf-modified-223dd0e92e4dc0849129cee5-="">
              <i class="fa-solid fa-house-chimney-crack" style="color: #310d64;"></i>
              <label style="color: #310d64 ! important;">Home</label>
            </a>
            <a href="/vip" class="nav-link " data-cf-modified-223dd0e92e4dc0849129cee5-="">
              <i class="fa-solid fa-store"></i>
              <label>Product</label>
            </a>
            <a href="/my-team" class="nav-link " data-cf-modified-223dd0e92e4dc0849129cee5-="">
              <i class="fa-solid fa-envelope-open-text"></i>
              <label>Promotion</label>
            </a>
            <a href="/mine" class="nav-link " data-cf-modified-223dd0e92e4dc0849129cee5-="">
              <i class="fas fa-user-circle"></i>
              <label>Profile</label>
            </a>
          </div>
        </div>
      </div>
    </div>



    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js" type="223dd0e92e4dc0849129cee5-text/javascript"></script>
    <script type="text/javascript">
      // Initialize Swiper
      document.addEventListener("DOMContentLoaded", function () {
        new Swiper('.swiper-container', {
          loop: true,
          autoplay: {
            delay: 3000,
            disableOnInteraction: false,
          },
          pagination: {
            el: '.swiper-pagination',
            clickable: true,
          },
        });

        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
      });

      // Close notice popup
      function closeNotice() {
        document.getElementById('noticePopup').style.display = 'none';
      }

      document.addEventListener('DOMContentLoaded', function () {
        document.querySelector('.notice-close').addEventListener('click', function () {
          document.getElementById('noticePopup').style.display = 'none';
        });

        document.getElementById('telegramBtn').addEventListener('click', function () {
          window.open('/profelar.php', '_blank');
        });
      });

      let currentProductId = null;

      function openProductModal(product) {
        currentProductId = product.id;

        $('#modalProductImage').attr('src', product.image);
        $('#modalProductName').text(product.name);
        $('#modalProductPrice').text('৳' + product.price);
        $('#modalDailyIncome').text('৳' + product.daily_income);
        $('#modalTotalIncome').text('৳' + (product.daily_income * product.days));
        $('#modalProductDays').text(product.days + ' Days');
        $('#modalProductROI').text(Math.round((product.daily_income * product.days * 100) / product.price) + '%');

        $('#productModal').modal('show');
      }

      // Confirm Purchase
      $('#confirmPurchaseBtn').click(function () {
        if (currentProductId) {
          purchaseProduct(currentProductId);
        }
      });

      function purchaseProduct(id) {
        $.get("/home/purchase_product", {
          id: id
        }, function (response) {
          if (response.status == "success") {
            alert(response.msg);
            $('#productModal').modal('hide');
            location.reload();
          } else if (response.msg === "Insufficient Balance, Please Recharge Wallet to Continue") {
            window.location.href = "/home/recharge";
          } else {
            alert(response.msg);
          }
        }).fail(function () {
          alert("An error occurred. Please try again.");
        });
      }

      function showPackagePopup() {
        document.getElementById('PackagePopup').classList.add('active');
      }
      
      function showTelegramPopup() {
        document.getElementById('telegramPopup').classList.add('active');
      }

      function closePackagePopup() {
        document.getElementById('PackagePopup').classList.remove('active');
      }
      
      function closePopup() {
        document.getElementById('telegramPopup').classList.remove('active');
      }
    </script>


    <style>
      /* Footer Navigation */
      .menubar-area {
        position: fixed;
        bottom: 0px;
        left: 0;
        right: 0;
        background: #fff;
        backdrop-filter: blur(10px);
        z-index: 1000;
        width: 100%;
        padding: 10px;
        padding-top: 20px !important;
        padding-bottom: 5px !important;
        box-shadow: 0 12px 26px 0 rgba(0, 0, 0, 0.3);
        border-radius: 25PX 25PX 0PX 0PX;
        margin: 0px;
      }

      .menubar-nav {
        display: flex;
        justify-content: space-around;
        padding: 10px 0;
      }

      .nav-link {
        display: flex;
        flex-direction: column;
        align-items: center;
        color: rgba(255, 255, 255, 0.7);
        text-decoration: none;
        font-size: 12px;
        padding: 5px 10px;
        border-radius: 10px;
        transition: all 0.3s ease;
      }

      .mb-0 {
        margin-bottom: 0 !important;
        color: #ffffff;
        text-align: center;
      }

      .nav-link i {
        font-size: 28px;
        margin-bottom: 5px;
        color: #65656569;
      }

      .nav-link.active,
      .nav-link:hover {
        color: white;
        background: rgba(255, 255, 255, 0.2);
      }

      .nav-link label {
        margin-top: 2px;
        font-size: 12px;
        color: #65656569 ! important;
      }
    </style>




  </div>
  <!--**********************************
    Scripts
***********************************-->
@include('alert-message')

  <script src="/assets/app/js/jquery.js" type="text/javascript"></script>
  <script src="/assets/app/vendor/bootstrap/js/bootstrap.bundle.min.js" type="text/javascript"></script>
  <script src="/assets/app/js/settings.js" type="text/javascript"></script>
  <script src="/assets/app/js/custom.js?v=45" type="text/javascript"></script>
  <script src="/assets/app/js/dz.carousel.js" type="text/javascript"></script>
  <script src="/assets/app/vendor/swiper/swiper-bundle.min.js" type="text/javascript"></script>

  <div id="responsePopup" style="
display: none;
 position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background-color:#310d64;
    color: white;
    width: 65%;
    text-align: center;
    padding: 12px 16px;
    border-radius: 10px;
    font-size: 14px;
    font-weight: 500;
    box-shadow: rgba(0, 0, 0, 0.38) 0px 4px 12px;
    z-index: 9999;
    opacity: 1;
    transition: opacity 0.3s;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.16);"></div>
  <div id="popupOverlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; 
     background:rgba(0,0,0,0.3); z-index:9998;"></div>



  <script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function () {
      document.querySelectorAll('input, select, textarea').forEach(function (element) {
        element.oninvalid = function (event) {
          event.preventDefault();
          notify('error', this.validationMessage);
        };
        element.oninput = function () {
          this.setCustomValidity('');
        };
      });

      window.scrollTo(0, 0);

    });

    (function versionCheckAndCleanup() {
      const CURRENT_VERSION = 'v45';
      const STORAGE_VERSION_KEY = 'v45';

      const savedVersion = localStorage.getItem(STORAGE_VERSION_KEY);

      if (savedVersion !== CURRENT_VERSION) {
        console.log('[Cache] Version changed. Clearing stored data...');

        Object.keys(localStorage).forEach(key => {
          if (key.startsWith('swrcache-') || key.startsWith('app_')) {
            localStorage.removeItem(key);
          }
        });

        const dbDeleteRequest = indexedDB.deleteDatabase('AppCacheDB');
        dbDeleteRequest.onsuccess = function () {
          console.log('[IndexedDB] AppCacheDB deleted due to version change.');
        };
        dbDeleteRequest.onerror = function (event) {
          console.error('[IndexedDB] Error deleting DB:', event);
        };

        localStorage.setItem(STORAGE_VERSION_KEY, CURRENT_VERSION);
      } else {
        console.log('[Cache] App version unchanged:', CURRENT_VERSION);
      }
    })();

    function closeIframe() {
      var popup = document.getElementById("popup");
      var iframe = document.getElementById("youtubeVideo");
      iframe.src = iframe.src;
      popup.style.display = "none";
    }

    window.addEventListener("popstate", function (event) {
      location.reload();
    });

    function convertAllFormToAjax() {
      document.querySelectorAll("form").forEach((form) => {
        form.onsubmit = (e) => {
          form.querySelector("button[type=submit]").disabled = true;
          let buttonText = form.querySelector("button[type=submit]").innerHTML;
          form.querySelector("button[type=submit]").innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
          e.preventDefault();
          const formData = $(form).serializeArray();
          const jsonData = {};
          formData.forEach(field => {
            jsonData[field.name] = field.value;
          });
          $.ajax({
            url: form.action,
            method: form.method,
            contentType: 'application/json',
            data: JSON.stringify(jsonData),
            success: function (response) {
              try {
                onRequestResponse(response);
              } catch (e) {
                console.log("error", e);
              }
              form.querySelector("button[type=submit]").disabled = false;
              form.querySelector("button[type=submit]").innerHTML = buttonText;
            },
            error: function (xhr, status, error) {
              try {
                onRequestError(error);
              } catch (e) {
                console.log("error", e);
              }
              form.querySelector("button[type=submit]").disabled = false;
              form.querySelector("button[type=submit]").innerHTML = buttonText;
            }
          });
        };
      });
    }

    function showPopup(message) {
      document.getElementById("responsePopup").innerText = message;
      document.getElementById("responsePopup").style.display = "block";
      document.getElementById("popupOverlay").style.display = "block";
      const toast = document.getElementById("responsePopup");
      toast.style.display = "block";
      toast.style.opacity = "1";
    }

    function hidePopup() {
      document.getElementById("responsePopup").style.display = "none";
      document.getElementById("popupOverlay").style.display = "none";
    }

    function notify(status, msg) {
      if (status === "success" || status === "error") {
        showPopup(`${msg}`);
        setTimeout(() => {
          hidePopup();
        }, 1500);
      }
    }

    window.first = false;

    const dbName = 'AppCacheDB';
    const dbVersion = 1;
    const storeName = 'pages';
    let db;

    function openIndexedDB(callback) {
      const request = indexedDB.open(dbName, dbVersion);

      request.onupgradeneeded = function (event) {
        db = event.target.result;
        if (!db.objectStoreNames.contains(storeName)) {
          db.createObjectStore(storeName, {
            keyPath: 'path'
          });
        }
      };

      request.onsuccess = function (event) {
        db = event.target.result;
        if (callback) callback();
      };

      request.onerror = function (event) {
        console.error("IndexedDB error:", event.target.errorCode);
      };
    }

    function savePageToIndexedDB(path, data) {
      if (!db) return;

      const tx = db.transaction([storeName], 'readwrite');
      const store = tx.objectStore(storeName);
      const item = {
        path,
        data,
        timestamp: Date.now()
      };
      store.put(item);
    }

    function getPageFromIndexedDB(path, callback) {
      if (!db) {
        callback(null);
        return;
      }

      const tx = db.transaction([storeName], 'readonly');
      const store = tx.objectStore(storeName);
      const request = store.get(path);

      request.onsuccess = function (event) {
        callback(event.target.result);
      };

      request.onerror = function (event) {
        console.error("Error reading IndexedDB:", event.target.errorCode);
        callback(null);
      };
    }

    function cleanupIndexedDB(maxEntries = 20) {
      if (!db) return;

      const tx = db.transaction([storeName], 'readwrite');
      const store = tx.objectStore(storeName);
      const items = [];

      store.openCursor().onsuccess = function (event) {
        const cursor = event.target.result;
        if (cursor) {
          items.push(cursor.value);
          cursor.continue();
        } else {
          if (items.length > maxEntries) {
            const excess = items.sort((a, b) => a.timestamp - b.timestamp)
              .slice(0, items.length - maxEntries);
            excess.forEach(item => store.delete(item.path));
          }
        }
      };
    }

    function staleWhileRevalidate(path, callback) {
      const ttl = 7 * 24 * 60 * 60 * 1000; // 7 days

      getPageFromIndexedDB(path, function (cacheItem) {
        const now = Date.now();
        const isValid = cacheItem && now - cacheItem.timestamp < ttl;

        if (isValid) {
          callback(cacheItem.data);
        }

        let postData = {
          turbo: "1"
        };
        if (window.first) {
          postData.first = 1;
          window.first = false;
        }

        $.get(path, postData, (fresh) => {
          if (!isValid || fresh !== cacheItem?.data) {
            savePageToIndexedDB(path, fresh);
            cleanupIndexedDB();
            callback(fresh);
          }
        });
      });
    }

    // Initialize IndexedDB
    openIndexedDB(() => {
      console.log("IndexedDB ready");
    });

    function cleanupCache(maxEntries = 20) {
      const keys = Object.keys(localStorage).filter(k => k.startsWith('swrcache-'));

      if (keys.length <= maxEntries) return;

      const sorted = keys.map(k => ({
        key: k,
        timestamp: (() => {
          try {
            return JSON.parse(localStorage.getItem(k)).timestamp || 0;
          } catch {
            return 0;
          }
        })()
      })).sort((a, b) => a.timestamp - b.timestamp);

      const excess = sorted.length - maxEntries;
      for (let i = 0; i < excess; i++) {
        localStorage.removeItem(sorted[i].key);
      }
    }

    window.navRequestId = window.navRequestId || 0;

    function navigate(path, complete = true) {
      window.location.href = path;
     
    }

    function loadFromCache(data, complete, path) {
      if (complete) {
        document.documentElement.innerHTML = data;
        $("#loader").hide();
        setTimeout(() => {
          document.querySelectorAll("script").forEach((old_script) => {
            let script = document.createElement("script");
            if (old_script.src != "") {
              script.src = old_script.src;
              old_script.remove();
              document.body.append(script);
            } else {
              if (old_script.className != "afterLoadScript") {
                script.innerHTML = old_script.innerHTML;
                document.body.append(script);
                old_script.remove();
              }
            }
          });

          document.querySelectorAll("link").forEach((old_link) => {
            let link = document.createElement("link");
            link.href = old_link.href;
            link.rel = "stylesheet";
            old_link.remove();
            document.head.append(link);
          });

          executeComponentScript();
          convertAllFormToAjax();
          try {
            $('#preloader').hide();
          } catch (e) {}
        }, 50);
      } else {
        document.querySelector("#innerBody").innerHTML = data;
        executeComponentScript();
        convertAllFormToAjax();
      }

      history.pushState({}, "", path);
    }

    function closeDropdown(ele) {
      ele.parentElement.parentElement.className = ele.parentElement.parentElement.className.replace("show", "");
    }

    function activeNavigation(ele) {
      $(".side-menu__item").removeClass("active");
      ele.className = 'side-menu__item active';
      if (document.documentElement.clientWidth <= 992) {
        document.querySelector("html").setAttribute("data-toggled", "close");
        document.querySelector("#responsive-overlay").className = '';
      }
    }

    window.onload = function () {
      executeComponentScript();
      convertAllFormToAjax();
    }

    function executeComponentScript() {
      let scriptComponent = document.querySelector('.afterLoadScript');
      if (scriptComponent) {
        try {
          eval(scriptComponent.innerHTML);
        } catch (e) {
          console.log("Error", e);
        }
      }
    }
  </script>


  <!--<script src="index.js" defer></script>-->
  <!--<script src="/assets/app/js/jquery.js"></script>-->
  <!--<script src="/assets/app/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>-->
  <!--<script src="/assets/app/js/settings.js"></script>-->
  <!--<script src="/assets/app/js/custom.js"></script>-->
  <!--<script src="/assets/app/js/dz.carousel.js"></script><!-- Swiper -->
  <!--<script src="/assets/app/vendor/swiper/swiper-bundle.min.js"></script><!-- Swiper -->

</body>

</html>

